/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Sets;
import cz.insophy.inplan.sdgraph.SdgEdge;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.sdgraph.StoreDependencyGraphImpl;
import cz.insophy.inplan.shop.Material;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

abstract class AbstractSdgNode
implements SdgNode {
    StoreDependencyGraphImpl graph;
    ImmutableListMultimap<SdgNode, SdgEdge> outgoingEdges;
    ImmutableListMultimap<SdgNode, SdgEdge> incomingEdges;
    ImmutableList<SdgEdge> allOutgoingEdges;
    ImmutableList<SdgEdge> allIncomingEdges;

    AbstractSdgNode() {
    }

    @Override
    public Set<SdgNode> getDirectSuccessors() {
        return this.outgoingEdges.keySet();
    }

    @Override
    public Set<SdgNode> getDirectPredecessors() {
        return this.incomingEdges.keySet();
    }

    @Override
    public List<SdgEdge> getOutgoingEdges() {
        return this.allOutgoingEdges;
    }

    @Override
    public List<SdgEdge> getIncomingEdges() {
        return this.allIncomingEdges;
    }

    @Override
    public List<SdgEdge> getEdgesTo(SdgNode other) {
        return this.outgoingEdges.get((Object)other);
    }

    @Override
    public List<SdgEdge> getEdgesFrom(SdgNode other) {
        return this.incomingEdges.get((Object)other);
    }

    @Override
    public boolean isLeaf() {
        return this.outgoingEdges.isEmpty();
    }

    @Override
    public boolean isRoot() {
        return this.incomingEdges.isEmpty();
    }

    @Override
    public double getTotalIncomingQty(@Nonnull Material material) {
        return AbstractSdgNode.getTotalQty(this.getIncomingEdges(), material);
    }

    @Override
    public double getTotalOutgoingQty(@Nonnull Material material) {
        return AbstractSdgNode.getTotalQty(this.getOutgoingEdges(), material);
    }

    @Override
    public double getMttQty(@Nonnull Material material, Collection<? extends SdgNode> destinationNodes) {
        return this.graph.getMttQty(this, material, destinationNodes);
    }

    @Override
    public double getMttQty(Collection<? extends SdgNode> destinationNodes) {
        return this.graph.getMttQty(this, destinationNodes);
    }

    @Override
    public Set<SdgNode> getMttDestinations() {
        return this.graph.getMttRelated(this, StoreDependencyGraph.Direction.TO_FINALS);
    }

    @Override
    public Set<SdgNode> getMttSources() {
        return this.graph.getMttRelated(this, StoreDependencyGraph.Direction.TO_SOURCES);
    }

    @Override
    public double getProbabilisticMttQty(Set<SdgNode> destinations) {
        double outgoing = 0.0;
        for (Material material : this.getOutgoingMaterials()) {
            outgoing += this.getTotalOutgoingQty(material);
        }
        return outgoing * this.getProbabilisticMttFraction(destinations);
    }

    private Set<Material> getOutgoingMaterials() {
        HashSet<Material> materials = Sets.newHashSet();
        for (SdgEdge edge : this.getOutgoingEdges()) {
            materials.add(edge.getMaterial());
        }
        return materials;
    }

    private double getProbabilisticMttFraction(Set<SdgNode> destinations) {
        if (destinations.contains(this)) {
            return 1.0;
        }
        if (this.isLeaf()) {
            return 0.0;
        }
        double totalQty = 0.0;
        double frac = 0.0;
        for (SdgNode successor : this.getDirectSuccessors()) {
            double nodeQty = 0.0;
            for (SdgEdge edge : this.getEdgesTo(successor)) {
                nodeQty += edge.getQty();
                totalQty += edge.getQty();
            }
            frac += ((AbstractSdgNode)successor).getProbabilisticMttFraction(destinations) * nodeQty;
        }
        if (totalQty > 0.0) {
            frac /= totalQty;
        }
        return frac;
    }

    private static double getTotalQty(List<SdgEdge> edges, @Nonnull Material material) {
        double q = 0.0;
        for (SdgEdge edge : edges) {
            if (material != edge.getMaterial()) continue;
            q += edge.getQty();
        }
        return q;
    }
}

